#include <p30fxxxx.h>
#include "outcompare.h"

/**************************************************************************
* Function Name  :  CloseOC1                                              *
* Description    :  This routine disables the Output Compare and its      *
*                   interrupt bits.                                       *
* Parameter      :  None                                                  *
* Return Value   :  None                                                  *
**************************************************************************/
void CloseOC1()
{   
    IEC0bits.OC1IE = 0;  /* Disable the Interrupt bit in IEC Register */
    OC1CONbits.OCM = 0;  /* Turn off Output Compare1 */
    IFS0bits.OC1IF = 0;  /* Disable the Interrupt Flag bit in IFS Register */
}

/***********************************************************************
* Function Name :  CloseOC2                                            *
* Description   :  This routine disables the Output Compare and its    *
*                  interrupt bits.                                     *
* Parameter     :  None                                                *
* Return Value  :  None                                                *
***********************************************************************/
void CloseOC2()
{   
    IEC0bits.OC2IE = 0; /* Disable the Interrupt bit in IEC Register */
    OC2CONbits.OCM = 0; /* Turn off Output Compare2 */
    IFS0bits.OC2IF = 0; /* Disable the Interrupt Flag bit in IFS Register */
}

/************************************************************************
*    Function Name:  ConfigIntOC1                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC1(unsigned int config)
{   
    IFS0bits.OC1IF = 0 ;                /* Clear IF bit */
    IPC0bits.OC1IP=(config &0x0007);    /* Assign Interrupt Priority */ 
    IEC0bits.OC1IE=(config &0x0008)>>3; /* Enable/disable Interrupt */ 
}

/************************************************************************
*    Function Name:  ConfigIntOC2                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC2(unsigned int config)
{
    IFS0bits.OC2IF = 0;                   /* Clear IF bit */
    IPC1bits.OC2IP = (config &0x0007);    /* Assign Interrupt Priority */ 
    IEC0bits.OC2IE = (config &0x0008)>>3; /* Enable/disable Interrupt */
}

/*****************************************************************************
*    Function Name:  OpenOC1                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC1(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC1CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC1RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC1R = value2;      /* assign value2 to OCxR Main Register*/  
    OC1CON = config;    /* assign config to OCxCON Register*/
}

/*****************************************************************************
*    Function Name:  OpenOC2                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC2(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC2CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC2RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC2R = value2;      /* assign value2 to OCxR Main Register*/  
    OC2CON = config;    /* assign config to OCxCON Register*/
}

/**********************************************************************
*    Function Name:  ReadDCOC1PWM                                     *
*    Description:    This routine reads duty cycle from Secondary     *
*                    register  in PWM mode                            *
*    Parameters:     None                                             *
*    Return Value:   unsigned int: duty cycle from Secondary register *
**********************************************************************/
unsigned int ReadDCOC1PWM()
{
    /* check if OC is in PWM Mode */

    if((OC1CONbits.OCM & 0x06) == 0x06)
    {       
        return OC1RS;   /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/***********************************************************************
*    Function Name:  ReadDCOC2PWM                                      *
*    Description:    This routine reads duty cycle from Secondary      *
*                    register in PWM mode                              *
*    Parameters:     None                                              *
*    Return Value:   unsigned int: duty cycle from Secondary register  *
***********************************************************************/
unsigned int ReadDCOC2PWM()
{
    /* check if OC is in PWM Mode */
    if((OC2CONbits.OCM & 0x06) == 0x06)
    {       
        return OC2RS;/* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadRegOC1		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC1(char reg )
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC1CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC1R; /* Output Compare main Register */
            
        }     
        return OC1RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  ReadRegOC2		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC2(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC2CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC2R; /* Output Compare main Register */
            
        }     
        return OC2RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  SetDCOC1PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC1PWM(unsigned int dutycycle)
{   
    /* check if OC is in PWM Mode */
    if((OC1CONbits.OCM & 0x06) == 0x06) 
       OC1RS = dutycycle;   /* assign to OCRS */
}

/********************************************************************
*    Function Name:  SetDCOC2PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC2PWM(unsigned int dutycycle)
{       
    /* check OC is in PWM Mode */
    if((OC2CONbits.OCM & 0x06) == 0x06) 
       OC2RS = dutycycle; /* assign to OCRS */
}

/*************************************************************************
*    Function Name:  SetPulseOC1                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC1(unsigned int pulse_start, unsigned int pulse_stop)
{   

    /* check if OC is in NON PWM Mode */
    if( (OC1CONbits.OCM & 0x06) != 0x06) 
    {
        OC1R = pulse_start;/* assign pulse_start to Main Register */
        OC1RS = pulse_stop;/* assign pulse_stop to Secondary Register */
    }
}


/*************************************************************************
*    Function Name:  SetPulseOC2                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC2(unsigned int pulse_start, unsigned int pulse_stop)
{   

    /* check if OC is in NON PWM Mode. */
    if( (OC2CONbits.OCM & 0x06) != 0x06) 
    {
        OC2R = pulse_start;/* assign pulse_start to Main Register */
        OC2RS = pulse_stop;/* assign pulse_stop to Secondary Register */
    }
}

/* These devices support OutputCompare 3 and OutputCompare 4 */
#if defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/************************************************************************
* Function Name  : CloseOC3                                             *
* Description    : This routine disables the Output Compare and its     *
*                  interrupt bits.                                      *
* Parameter      : None                                                 *
* Return Value   : None                                                 *
************************************************************************/
void CloseOC3()
{   
    IEC1bits.OC3IE = 0;/* Disable the Interrupt bit in IEC Register */
    OC3CONbits.OCM = 0;/* Turn off Output Compare 3 */
    IFS1bits.OC3IF = 0;/* Disable the Interrupt Flag bit in IFS Register */
}

/*********************************************************************
* Function Name  :  CloseOC4                                         *
* Description    :  This routine disables the Output Compare and its *
*                   interrupt bits.                                  *
* Parameters     :  None                                             *
* Return Value   :  None                                             *
*********************************************************************/
void CloseOC4()
{   
    IEC1bits.OC4IE = 0;/* Disable the Interrupt bit in IEC Register */
    OC4CONbits.OCM = 0;/* Turn off Output Compare 4 */
    IFS1bits.OC4IF = 0;/* Disable the Interrupt Flag bit in IFS Register */
}

/************************************************************************
*    Function Name:  ConfigIntOC3                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC3(unsigned int config)
{
    IFS1bits.OC3IF = 0;                    /* Clear IF bit */
    IPC4bits.OC3IP = (config &0x0007);     /* Assign Interrupt Priority */
    IEC1bits.OC3IE = (config &0x0008)>>3;  /* Enable/disable Interrupt */
}

/************************************************************************
*    Function Name:  ConfigIntOC4                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC4(unsigned int config)
{
    IFS1bits.OC4IF = 0;                   /* Clear IF bit */
    IPC5bits.OC4IP = (config &0x0007);    /* Assign Interrupt Priority */ 
    IEC1bits.OC4IE = (config &0x0008)>> 3;/* Enable/disable Interrupt */
}

/*****************************************************************************
*    Function Name:  OpenOC3                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC3(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC3CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC3RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC3R = value2;      /* assign value2 to OCxR Main Register*/  
    OC3CON = config;    /* assign config to OCxCON Register*/
}

/*****************************************************************************
*    Function Name:  OpenOC4                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC4(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC4CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC4RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC4R = value2;      /* assign value2 to OCxR Main Register*/  
    OC4CON = config;    /* assign config to OCxCON Register*/
}

/********************************************************************
*    Function Name:  ReadDCOC3PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register in PWM mode                           *
*    Parameters:     None                                           *
*    Return Value:  unsigned int: duty cycle from Secondary register*
********************************************************************/
unsigned int ReadDCOC3PWM()
{
    /* check if OC is in PWM Mode */
    if((OC3CONbits.OCM & 0x06) == 0x06)
    {       
        return OC3RS;/* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadDCOC4PWM                                   *
*    Description:    This routine reads duty cycle from Master      *
*                    register in PWM mode                           *
*    Parameters:     None                                           *
*    Return Value:   unsigned int:duty cycle from Secondary register*
********************************************************************/
unsigned int ReadDCOC4PWM()
{
    /* check if OC is in PWM Mode */
    if((OC4CONbits.OCM & 0x06) == 0x06)
    {       
        return OC4RS;       /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadRegOC3		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC3(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC3CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC3R; /* Output Compare main Register */
            
        }     
        return OC3RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  ReadRegOC4		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC4(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC4CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC4R; /* Output Compare main Register */
            
        }     
        return OC4RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  SetDCOC3PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC3PWM(unsigned int dutycycle)
{   
    
    /* check OC is in PWM Mode */
    if((OC3CONbits.OCM & 0x06) == 0x06) 
       OC3RS = dutycycle;  /* assign to OCRS */
}

/********************************************************************
*    Function Name:  SetDCOC4PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC4PWM(unsigned int dutycycle)
{   
    
    /* check OC is in PWM Mode.*/
    if((OC4CONbits.OCM & 0x06) == 0x06) 
       OC4RS = dutycycle; /* assign to OCRS */
}

/*************************************************************************
*    Function Name:  SetPulseOC3                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC3(unsigned int pulse_start, unsigned int pulse_stop)
{   

    /* check if OC is in NON PWM Mode. */
    if( (OC3CONbits.OCM & 0x06) != 0x06) 
    {
        OC3R = pulse_start; /* assign pulse_start to Main Register */
        OC3RS = pulse_stop; /* assign pulse_stop to Secondary Register */
    }
}

/*************************************************************************
*    Function Name:  SetPulseOC4                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC4(unsigned int pulse_start, unsigned int pulse_stop)
{   
    /* check if OC is in NON PWM Mode. */
    if( (OC4CONbits.OCM & 0x06) != 0x06) 
    {
        OC4R = pulse_start;/* assign pulse_start to Main Register */
        OC4RS = pulse_stop;/* assign pulse_stop to Secondary Register */
    }
}

#endif

/* This devices support OutputCompare 5 thru OutputCompare 8 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
* Function Name :  CloseOC5                                         *
* Description   :  This routine disables the Output Compare and its *
*                  interrupt bits.                                  *
* Parameter     :  None                                             *
* Return Value  :  None                                             *
********************************************************************/
void CloseOC5()
{   
    IEC2bits.OC5IE = 0;/* Disable the Interrupt bit in IEC Register */
    OC5CONbits.OCM = 0;/* Turn off Output Compare 5 */
    IFS2bits.OC5IF = 0;/* Disable the Interrupt Flag bit in IFS Register */
}

/*********************************************************************
* Function Name :  CloseOC6                                          *
* Description   :  This routine disables the Output Compare and its  *
*                  interrupt bits.                                   *
* Parameter     :  None                                              *
* Return Value  :  None                                              *
*********************************************************************/
void CloseOC6()
{   
    IEC2bits.OC6IE = 0;/* Disable the Interrupt bit in IEC Register */
    OC6CONbits.OCM = 0;/* Turn off Output Compare6 */
    IFS2bits.OC6IF = 0;/* Disable the Interrupt Flag bit in IFS Register */
}

/********************************************************************
* Function Name :  CloseOC7                                         *
* Description   :  This routine disables the Output Compare and its *
*                  interrupt bits.                                  *
* Parameter     :  None                                             *
* Return Value  :  None                                             *
********************************************************************/
void CloseOC7()
{   
    IEC2bits.OC7IE = 0;/* Disable the Interrupt bit in IEC Register */
    OC7CONbits.OCM = 0;/* Turn off Output Compare 7 */
    IFS2bits.OC7IF = 0;/* Disable the Interrupt Flag bit in IFS Register */
}

/********************************************************************
* Function Name :  CloseOC8                                         *
* Description   :  This routine disables the Output Compare and its *
*                  interrupt bits.                                  *
* Parameter     :  None                                             *
* Return Value  :  None                                             *
********************************************************************/
void CloseOC8()
{   
    IEC2bits.OC8IE = 0; /* Disable the Interrupt bit in IEC Register */
    OC8CONbits.OCM = 0; /* Turn off Output Compare 8 */
    IFS2bits.OC8IF = 0; /* Disable the Interrupt Flag bit in IFS Register */
}

/************************************************************************
*    Function Name:  ConfigIntOC5                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC5(unsigned int config)
{
    IFS2bits.OC5IF = 0;                  /* Clear IF bit */
    IPC8bits.OC5IP = (config &0x0007);   /* Assign Interrupt Priority */
    IEC2bits.OC5IE = (config &0x0008)>>3;/* Enable/disable Interrupt */
}

/************************************************************************
*    Function Name:  ConfigIntOC6                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC6(unsigned int config)
{
    IFS2bits.OC6IF = 0;                   /* Clear IF bit */
    IPC8bits.OC6IP=(config &0x0007);      /* Assign Interrupt Priority */
    IEC2bits.OC6IE=(config &0x0008)>>3;   /* Enable/disable Interrupt */
}

/************************************************************************
*    Function Name:  ConfigIntOC7                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC7(unsigned int config)
{
    IFS2bits.OC7IF = 0;                    /* Clear IF bit */
    IPC8bits.OC7IP=(config &0x0007);       /* Assign Interrupt Priority */
    IEC2bits.OC7IE=(config &0x0008)>>3;    /* Enable/disable Interrupt */
}

/************************************************************************
*    Function Name:  ConfigIntOC8                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/
void ConfigIntOC8(unsigned int config)
{
    IFS2bits.OC8IF = 0;                  /* Clear IF bit */
    IPC8bits.OC8IP=(config &0x0007);     /* Assign Interrupt Priority */

    IEC2bits.OC8IE=(config &0x0008)>>3;  /* Enable/disable Interrupt */
}

/*****************************************************************************
*    Function Name:  OpenOC5                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC5(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC5CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC5RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC5R = value2;      /* assign value2 to OCxR Main Register*/  
    OC5CON = config;    /* assign config to OCxCON Register*/
}

/*****************************************************************************
*    Function Name:  OpenOC6                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC6(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC6CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC6RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC6R = value2;      /* assign value2 to OCxR Main Register*/  
    OC6CON = config;    /* assign config to OCxCON Register*/
}

/*****************************************************************************
*    Function Name:  OpenOC7                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC7(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC7CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC7RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC7R = value2;      /* assign value2 to OCxR Main Register */  
    OC7CON = config;    /* assign config to OCxCON Register */
}

/*****************************************************************************
*    Function Name:  OpenOC8                                                 *
*    Description:    This routine configures output compare module and loads *
*                    the compare registers                                   *
*    Parameters  :   unsigned int config, unsigned int value1,               *
*                    unsigned int value2                                     *
*    Return Value:   None                                                    *
*    Notes           value1 is the compare value for the OCRS register       *
*                    value2 is the compare value for the OCR register        *
*****************************************************************************/
void OpenOC8(unsigned int config, unsigned int value1, unsigned int value2)
{
    OC8CONbits.OCM = 0; /* turn off OC before switching to new mode */
    OC8RS = value1;     /* assign value1 to OCxRS Secondary Register */
    OC8R = value2;      /* assign value2 to OCxR Main Register */
    OC8CON = config;    /* assign config to OCxCON Register */
}

/********************************************************************
*    Function Name:  ReadDCOC5PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register in PWM mode                           *
*    Parameters:     None                                           *
*    Return Value:   unsigned int:duty cycle from Secondary register*
********************************************************************/
unsigned int ReadDCOC5PWM()
{
    /* check if OC is in PWM Mode */
    if((OC5CONbits.OCM &0x06) == 0x06)
    {       
        return OC5RS;       /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadDCOC6PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register  in PWM mode                          *
*    Parameters:     None                                           *
*    Return Value:   unsigned int:duty cycle from Secondary register*
********************************************************************/
unsigned int ReadDCOC6PWM()
{
    /* check if OC is in PWM Mode */
    if((OC6CONbits.OCM & 0x06) == 0x06)
    {       
        return OC6RS; /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadDCOC7PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register in PWM mode                           *
*    Parameters:     None                                           *
*    Return Value:   unsigned:int duty cycle from Secondary register*
********************************************************************/
unsigned int ReadDCOC7PWM()
{
    /* check if OC is in PWM Mode */

    if((OC7CONbits.OCM & 0x06) == 0x06)
    {       
        return OC7RS;       /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadDCOC8PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register  in PWM mode                          *
*    Parameters:     None                                           *
*    Return Value:   unsigned int:duty cycle from Secondary register*
********************************************************************/
unsigned int ReadDCOC8PWM()
{
    /* check if OC is in PWM Mode */

    if((OC8CONbits.OCM & 0x06) == 0x06)
    {       
        return OC8RS;       /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

/********************************************************************
*    Function Name:  ReadRegOC5		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC5(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC5CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC5R; /* Output Compare main Register */
            
        }     
        return OC5RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  ReadRegOC6		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC6(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC6CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC6R; /* Output Compare main Register */
            
        }     
        return OC6RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  ReadRegOC7		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC7(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC7CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC7R; /* Output Compare main Register */
            
        }     
        return OC7RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  ReadRegOC8		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/
unsigned int ReadRegOC8(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC8CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC8R; /* Output Compare main Register */
            
        }     
        return OC8RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

/********************************************************************
*    Function Name:  SetDCOC5PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC5PWM(unsigned int dutycycle)
{   
    /* check OC is in PWM Mode.*/
    if((OC5CONbits.OCM & 0x06) == 0x06) 
       OC5RS = dutycycle; /* assign to OCRS */
}

/********************************************************************
*    Function Name:  SetDCOC6PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC6PWM(unsigned int dutycycle)
{   
     /* check OC is in PWM Mode.*/
    if((OC6CONbits.OCM & 0x06) == 0x06) 
       OC6RS = dutycycle; /* assign to OCRS */
}

/********************************************************************
*    Function Name:  SetDCOC7PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC7PWM(unsigned int dutycycle)
{   
    /* check OC is in PWM Mode.*/
    if((OC7CONbits.OCM & 0x06) == 0x06) 
       OC7RS = dutycycle; /* assign to OCRS */
}

/********************************************************************
*    Function Name:  SetDCOC8PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/
void  SetDCOC8PWM(unsigned int dutycycle)
{   
    /* check OC is in PWM Mode.*/
    if((OC8CONbits.OCM & 0x06) == 0x06) 
       OC8RS = dutycycle; /* assign to OCRS */
}

/*************************************************************************
*    Function Name:  SetPulseOC5                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC5(unsigned int pulse_start, unsigned int pulse_stop)
{   
    /* check if OC is in NON PWM Mode. */
    if( (OC5CONbits.OCM & 0x06) != 0x06) 
    {
        OC5R = pulse_start; /* assign pulse_start to Main Register */
        OC5RS = pulse_stop; /* assign pulse_stop to Secondary Register */
    }
}

/*************************************************************************
*    Function Name:  SetPulseOC6                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC6(unsigned int pulse_start, unsigned int pulse_stop)
{   
    /* check if OC is in NON PWM Mode. */
    if( (OC6CONbits.OCM & 0x06) != 0x06) 
    {
        OC6R = pulse_start; /* assign pulse_start to Main Register */
        OC6RS = pulse_stop; /* assign pulse_stop to Secondary Register */
    }
}

/*************************************************************************
*    Function Name:  SetPulseOC7                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC7(unsigned int pulse_start, unsigned int pulse_stop)
{   
    /* check if OC is in NON PWM Mode. */
    if( (OC7CONbits.OCM & 0x06) != 0x06) 
    {
        OC7R = pulse_start; /* assign pulse_start to Main Register */
        OC7RS = pulse_stop; /* assign pulse_stop to Secondary Register */
    }
}

/*************************************************************************
*    Function Name:  SetPulseOC8                                         *
*    Description:    This routine writes the pulse_start to Main register*
*                    and pulse_stop to Secondary register                *
*    Parameters:     unsigned int pulse_start,unsigned int pulse_stop    *
*    Return Value:   None                                                *
*************************************************************************/
void SetPulseOC8(unsigned int pulse_start, unsigned int pulse_stop)
{   
    /* check if OC is in NON PWM Mode. */
    if( (OC8CONbits.OCM & 0x06) != 0x06) 
    {
        OC8R = pulse_start; /* assign pulse_start to Main Register */
        OC8RS = pulse_stop; /* assign pulse_stop to Secondary Register */
    }
}

#endif
